/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.jarjar.metadata.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;

public class VersionRangeSerializer
implements JsonSerializer<VersionRange>,
JsonDeserializer<VersionRange> {
    public VersionRange deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonPrimitive()) {
            try {
                return VersionRange.createFromVersionSpec((String)json.getAsString());
            }
            catch (InvalidVersionSpecificationException e) {
                throw new JsonParseException("Failed to parse version spec from: " + json.getAsString(), (Throwable)e);
            }
        }
        throw new JsonParseException("Expected a string or primitive value");
    }

    public JsonElement serialize(VersionRange src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(src.toString());
    }
}

